function grdd = num_hess(fcn,x0,grdh,y,kf_filtering_level,posterior,negative,GLOBALS) %#ok<INUSD>

% Computing numerical hessian using a central difference
%                    
% Inputs:
%
%       fcn = a string naming the objective function.
%        x0 = a column vector n*1, at which point the hessian is evaluated.
%      grdh = step size, use 0 if you want the recomended step size by Dennis and Schnabel
%
% Ouput:
%
%      grdd = hessian matrix (second derivative), n*n.


x0 = x0(:);

f0 = eval([fcn '(x0,y,kf_filtering_level,posterior,negative,GLOBALS)']);

% initializations

k = length(x0);
grdd = zeros(k);

% Computation of stepsize (dh)

if all(grdh)
    dh = grdh;
else
    ax0 = abs(x0);
    if all(x0)
        dax0 = x0 ./ ax0;
    else
        dax0 = 1;
    end
    stps = eps^(1/3);
    % eps: floating point relative accuracy or machine precision: 2.22e-16
    % stps: step size recommended by Dennis and Schnabel: 6.006e-6
    dh = stps * (max([ax0 (1e-2)*ones(k,1)]'))' .* dax0;
end

xdh = x0 + dh;
dh = xdh - x0;    % This increases precision slightly
dhm = dh(:,ones(k,1));
ee = eye(k) .* dhm;

i = 1;
while i <= k
    j = i;
    while j <= k
		disp([i j k]);
        fune1 = eval([fcn '(x0 + ee(:,i) + ee(:,j),y,kf_filtering_level,posterior,negative,GLOBALS)']);
        fune2 = eval([fcn '(x0 - ee(:,i) + ee(:,j),y,kf_filtering_level,posterior,negative,GLOBALS)']);
        fune3 = eval([fcn '(x0 + ee(:,i) - ee(:,j),y,kf_filtering_level,posterior,negative,GLOBALS)']);
        fune4 = eval([fcn '(x0 - ee(:,i) - ee(:,j),y,kf_filtering_level,posterior,negative,GLOBALS)']);
        grdd(i,j) = (fune1 - fune2 - fune3 + fune4)  / (4 * dh(i) * dh(j));
        disp(grdd(i,j))
        if i ~= j
            grdd(j,i) = grdd(i,j);
        end
    j = j+1;

    save atf;
    
    end
    i = i+1;
end




